   import java.awt.*;
   import java.text.*;
   import java.util.*;

/* This class provides a GUI: a window with several int fields, double 
   fields, and text fields. The current version has 0 int fields, 1 double
   field, and 5 String fields. Change the constructor call in method main to
   change the number of fields. It also has an additional choice box.<br><br>
   
   Whenever the button in the window is pressed, method buttonPressed is called.
   Place code in this method to read the fields, calculate, and store values
   back in the fields. The current version deals with locales, as discussed in 
   method buttonPressed.
   */
   
public class MyJLiveWindow extends JLiveWindow {
  
   // Store in int field 2 the sum of int fields 0 and 1.
   // Place code in the body of this method to process fields and store 
   // results in fields. Use
        
   //   getIntField(i)     for the number in int    field i; 0 is first field
   //   getdoubleField(i)  for the number in double field i; 0 is first field
   //   getStringField(i)  for the number in String field i; 0 is first field
   //   setIntField(i,v);      to store int value v in field i
   //   setDoubleField(i,v);   to store double value v in field i
   //   setStringField(i,v);   to store String value v in field i

   /** Process click of button titled "Ready!" */
   public Object buttonPressed() {
      // Using the selected locale, 
      // Place the value in double field 0 in
      // String field 0 as a decimal number
      // String field 1 as a currency
      // String field 2 as a percentage
         double v= getDoubleField(0);
         print3(v);
      
      // Place here any code that you are asked to write 
      
      return null;
   }
 
   /** Create an instance of me and show it */
   public static void main(String args[]) {
      // The first argument to MyJLiveWindow is the number of int fields,
      // the second argument is the number of double fields, and
      // the third argument is the number of text (or String) fields.
      MyJLiveWindow testJLiveWindow= new MyJLiveWindow(0, 1, 6);
      testJLiveWindow.showWindow();
   }
  
   /** Create my window with<br>
        max( min(i,MAX_FIELDS), 0) integer fields,<br>
        max( min(d,MAX_FIELDS), 0) double fields, and<br>
        max( min(s,MAX_FIELDS), 0) String fields<br>
        and a "ready" button */
   public MyJLiveWindow(int i, int d, int s) {
      super(i, d, s);
   }
   
   /** If j < 0, print d in all available currencies<br>
       If j = 0, print d in all available percentages<br>
       If j > 0, print d in all available number formats */
   public static void printInAll(double d, int j) {
      Locale[] locales= NumberFormat.getAvailableLocales();
      NumberFormat form= null;
      
      if (j < 0)  System.out.println("Currencies");
      if (j == 0) System.out.println("Percentages");
      if (j > 0)  System.out.println("Decimal format");
        for (int i= 0; i != locales.length; i++) {
            if (locales[i].getCountry().length() == 0) {
               continue; // skip --it's a language only
            }
            System.out.print(locales[i].getDisplayName());
            if (j < 0)  form= NumberFormat.getCurrencyInstance(locales[i]);
            if (j == 0) form= NumberFormat.getPercentInstance(locales[i]);
            if (j > 0)  form= NumberFormat.getInstance(locales[i]);
            
            try {
                System.out.print(": "  + form.format(d));
            } catch (IllegalArgumentException iae) {}
            try {
                System.out.println(" -> " + form.parse(form.format(d)));
            } catch (ParseException pe) {}     
         }    
   }
   
   /** Place v as a decimal number, currency, and percentage in the
       first three String fields, using the selected locale */
   public void print3(double v) {
      Locale loc= getLocale();
      NumberFormat form= NumberFormat.getInstance(loc);
      try {
          setStringField(0, "Decimal:   " + form.format(v));
      } catch (IllegalArgumentException iae) {}
      
      form= NumberFormat.getCurrencyInstance(loc);
      try {
          setStringField(1, "Currency:   " + form.format(v));
      } catch (IllegalArgumentException iae) {}
      
      form= NumberFormat.getPercentInstance(loc);
      try {
          setStringField(2, "Percentage: " + form.format(v));
      } catch (IllegalArgumentException iae) {}
   
   }
   
   
   
   
 
}

